﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.ComponentModel;
using System.Data;
using System.Threading;
using System.Drawing;

namespace PsgBase
{
    [ToolboxItemFilter("PSG", ToolboxItemFilterType.Require)]
    [Designer(typeof(System.Windows.Forms.Design.ControlDesigner))]
    public partial class baseDataGridView : DataGridView
    {
        #region Fields 

        private string fieldKey, serverTableName, valueKey;

        public baseDataGridView()
        {
            InitializeComponent();
        }

        #endregion

        #region Properties

        [Category("PSG")]
        public string PsgFieldKey
        {
            get { return fieldKey; }
            set { fieldKey = value; }
        }

        [Category("PSG")]
        public string PsgServerTableName
        {
            get { return serverTableName; }
            set { serverTableName = value; }
        }

        [Category("PSG")]
        public string PsgValueKey
        {
            get { return valueKey; }
            set { valueKey = value; }
        }

        #endregion

        private void baseDataGridView_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (!Base.psgIntf.ValidGridCellEnter(this, e))
                return;

            if (this.Rows[e.RowIndex] != null)
                this.Rows[e.RowIndex].Selected = true;

            if (e.ColumnIndex < 0)
                return;

            this.PsgValueKey = Convert.ToString(this.Rows[e.RowIndex].Cells[this.PsgFieldKey].Value);

            if (!string.IsNullOrEmpty(this.PsgValueKey))
                this.PsgValueKey = this.PsgValueKey.Trim();
        }

        private void baseDataGridView_VisibleChanged(object sender, EventArgs e)
        {
            if (!this.Visible)
                return;

            if (this.Rows.Count > 0 && this.SelectedRows.Count == 0)
                this.Rows[0].Selected = true;
        }
    }
}
